<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#424242" />
        <title><?php echo $this->customlib->getAppName(); ?></title>
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css"> 
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css"> 
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/style-main.css"> 
        <?php if ($this->customlib->getRTL() == "yes") { ?>
           <link rel="stylesheet" href="<?php echo base_url(); ?>backend/rtl/bootstrap-rtl/css/bootstrap-rtl.min.css"/>
           <link rel="stylesheet" href="<?php echo base_url(); ?>backend/rtl/dist/css/ss-rtlmain.css">      
        <?php } ?> 
        <style type="text/css">
            .table2 tr.border_bottom td {
                box-shadow: none;
                border-radius: 0;
                border-bottom: 1px solid #e6e6e6;
            }
            .table2 td {
                padding-bottom: 3px;
                padding-top: 6px;
            }
            .title{
                color: #0084B4;
                font-weight: 600 !important;
                font-size: 15px !important;;
                display: inline;

            }
            .product-description {
                display: block;
                color: #999;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;
            }
            .text-fine{
                color: #bf4f4d;
            }
        </style> 
    </head>
    <body style="background: #ededed;">
        <div class="container">
            <div class="row">
                <div class="paddtop20">
                    <div class="col-md-8 col-md-offset-2 text-center">
                        <img src="<?php echo $this->media_storage->getImageURL('uploads/hospital_content/logo/' . $setting['image']); ?>">
                    </div>
                    <div class="col-md-6 col-md-offset-3 mt20">
                        <div class="paymentbg">
                            <div class="invtext"><?php echo $this->lang->line('fees_payment_details'); 
                        ?> </div>
                            <div class="padd2 paddtzero">
                            <form action="#" method="post">
                                    <table class="table2" width="100%">
                                        <tr>
                                            <th><?php echo $this->lang->line('description'); ?></th>
                                            <th class="text-right text-rtl-left"><?php echo $this->lang->line('amount') ?></th>
                                        </tr>
                                        <tr class="border_bottom">
                                            <td> 
                                                <span class="title"><?php echo $this->lang->line("online_appointment_fees"); ?></span></td>
                                            <td class="text-right text-rtl-left"><?php echo $setting['currency_symbol'] . number_format((float) $standard_charge, 2, '.', ''); ?></td>
                                        </tr>
                                        <tr class="border_bottom">
                                            <td> 
                                                <span class="title"><?php echo $this->lang->line("tax"); ?></span></td>
                                            <td class="text-right text-rtl-left"><?php echo $setting['currency_symbol'] . number_format((float) $tax_amount, 2, '.', ''); ?></td>
                                        </tr>
                                        <!-- processing fees added -->
                                        <tr class="border_bottom">
                                            <td> 
                                                <span class="title"><?php echo $this->lang->line("processing_fees"); ?></span></td>
                                            <td class="text-right text-rtl-left"><?php  echo $setting['currency_symbol'].number_format((float)$gateway_processing_charge, 2, '.', ''); ?></td>
                                        </tr>
                                        <!-- processing fees added -->
                                        <tr class="bordertoplightgray">
                                            <td colspan="2" class="text-right text-rtl-left"><?php echo $this->lang->line('total');?>: <?php echo $setting['currency_symbol']. number_format((float)($amount), 2, '.', ''); ?></td>
                                        </tr>
                                        <tr class="bordertoplightgray">
                                            <td  bgcolor="#fff"><button type="submit" onclick="window.history.go(-1); return false;" name="search"  value="" class="btn btn-info"><i class="fa fa-chevron-left chevron-rtl-left"></i> <?php echo $this->lang->line('back'); ?> </button></td>
                                            <td  bgcolor="#fff" class="text-right text-rtl-left"><button type="button" onclick="pay()" name="search"  value="" class="btn btn-info"><?php echo $this->lang->line("pay_with_razorpay"); ?> <i class="fa fa-chevron-right chevron-rtl-right"></i></button>  </td>
                                        </tr>
                                    </table>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>  
            </div>
        </div>
        <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
        <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script> 
        <script>
            var SITEURL = "<?php echo base_url() ?>";

            //pay();
            function pay(e) {
            var totalAmount = <?php echo $total; ?>;
            var product_id = <?php echo $merchant_order_id; ?>;
            var options = {
                    "key": "<?php echo $key_id; ?>",
                    "amount": "<?php echo $total; ?>", // 2000 paise = INR 20
                    "name": "<?php echo $name; ?>",
                    "description": "<?php echo $title; ?>",
                    "currency": "<?php echo $currency_code; ?>",
                    "image": "<?php echo base_url('uploads/hospital_content/logo/' . $setting['image'].img_time()); ?>",
                    "handler": function (response) {

                        $.ajax({
                            url: '<?php echo $return_url; ?>',
                            type: 'post',
                            data: {
                                razorpay_payment_id: response.razorpay_payment_id, totalAmount: totalAmount, product_id: product_id,
                            },
                            success: function (msg) {

                                window.location.assign(SITEURL + 'patient/onlineappointment/checkout/successinvoice/' + msg)
                            }
                        });

                    },

                    "theme": {
                        "color": "#528FF0"
                    }
                };
                console.log(options);
                var rzp1 = new Razorpay(options);
                rzp1.open();

            }
        </script>
    </body>
</html>